Attribute VB_Name = "ErrCodes"
' DriverLINX/VB(tm) Result Codes
' (C) Copyright 1992 Scientific Software Tools, Inc.
' All Rights Reserved.

  ' Following result codes are standardized for all device drivers

  ' General

Global Const DL_NoErr = 0                       ' No error
Global Const DL_InternalErr = 1                 ' Internal driver error
Global Const DL_InvalidErrErr = 2               ' Invalid error number

  ' Service Request

Global Const DL_InvalidSRHandleErr = 5          ' Invalid service request handle
Global Const DL_OutOfBoundsErr = 10             ' Invalid service request
Global Const DL_InvalidWinHandleErr = 15        ' Invalid window handle
Global Const DL_ServiceNotSupportedErr = 20     ' Service not supported by driver
Global Const DL_InvalidDeviceNumErr = 25        ' Invalid logical device number
Global Const DL_InvalidSubsystemErr = 30        ' Invalid subsystem requested
Global Const DL_InvalidModeErr = 35             ' Invalid operation mode requested
Global Const DL_InvalidOpErr = 40               ' Invalid operation requested
Global Const DL_InvalidOpFlagsErr = 45          ' Invalid operation flags
Global Const DL_InvalidExtErr = 50              ' Invalid OEM extension handle
Global Const DL_DL_errTaskAlloc = 51            ' Cannot allocate task memory
Global Const DL_NotTaskErr = 55                 ' Service request not found
Global Const DL_SystemNotInit = 60              ' Subsystem not initialized
Global Const DL_WindowCreateErr = 65            ' Window creation error
Global Const DL_EditCanceled = 70               ' Edit cancelled
Global Const DL_ConfigureCanceled = 75          ' Configure canceled

  ' Logical Device Descriptors

Global Const DL_UnpairedLDDLockErr = 80         ' Lock/UnlockLDD calls cannot be nested

  ' Messages

Global Const DL_MsgQOverflow = 85               ' Message queue overflowed

  ' Driver and Device

Global Const DL_NotInit = 90                    ' Driver not initialized
Global Const DL_DriverBusyErr = 95              ' Driver busy
Global Const DL_NoHardwareErr = 100             ' No hardware detected
Global Const DL_InvAddress = 105                ' Invalid hardware base address
Global Const DL_HardwareMismatch = 110          ' Mismatch between hardware and LDD
Global Const DL_HardwareTestErr = 111           ' Hardware failed testing
Global Const DL_DeviceNotInitErr = 115          ' Device not initialized
Global Const DL_DeviceBusyErr = 120             ' Device busy
Global Const DL_DeviceInUse = 125               ' Device in use by another application

  ' Channels

Global Const DL_IllegalStartChan = 130          ' Start Channel is invalid
Global Const DL_IllegalEndChan = 135            ' End Channel is invalid
Global Const DL_StartAboveEnd = 140             ' Start > End not supported
Global Const DL_GainCode = 145                  ' Illegal gain requested
Global Const DL_NoGainErr = 150                 ' Programmable gain not supported
Global Const DL_ChanGainNotSup = 155            ' Channel/Gain List is not supported
Global Const DL_ChanConflict = 160              ' Start/Stop and Channel/Gain list specified
Global Const DL_ChanGainListOvr = 165           ' Channel/Gain list has too few/many entries
Global Const DL_BadChanInList = 170             ' Invalid channel in Channel/Gain list
Global Const DL_BadGainInList = 175             ' Invalid gain in Channel/Gain list
Global Const DL_CyclicConvIllegal = 180         ' Circular conversions not supported
Global Const DL_PermErr = 185                   ' Requested options not supported
Global Const DL_SimulErr = 190                  ' Simultaneous I/O not supported

  ' Buffers

Global Const DL_BufNotReqdErr = 195             ' I/O buffers not used
Global Const DL_IOValueErr = 196                ' I/O value not specified
Global Const DL_InvalidBLHandleErr = 200        ' Invalid buffer list handle
Global Const DL_InvalidNBuffer = 205            ' Number of buffers 0 or exceeds limit
Global Const DL_errBufAlloc = 206               ' Cannot allocate memory for buffers
Global Const DL_IncompleteScanErr = 210         ' Buffer does not hold integral # of scans
Global Const DL_InvNConv = 215                  ' Invalid # of conversions
Global Const DL_BufAllocErr = 220               ' Memory buffer allocation failed
Global Const DL_BufFreeErr = 225                ' Memory buffer deallocation failed
Global Const DL_NullHandleErr = 230             ' Memory handle is null
Global Const DL_NullPointerErr = 235            ' Memory pointer is null
Global Const DL_NilPointerErr = 240             ' Nil memory pointer
Global Const DL_NoObjForHandleErr = 245         ' Handle does not refer to valid memory object
Global Const DL_NumFormatNotSupported = 250     ' Requested number format not supported
Global Const DL_InvalidNumFormat = 255          ' Unrecognized number format

  ' Critical Section Flags

Global Const DL_NoCritSectErr = 260             ' Multiple critical sections are not supported
Global Const DL_NoCritSectOpt = 265             ' Unrecognized critical section option
Global Const DL_NoCritSectWarn = 270            ' Critical section may cause deadlock
Global Const DL_NoCritSectAllowd = 275          ' Critical section not allowed
Global Const DL_NoCritSectBegin = 280           ' Not in critical section
Global Const DL_NoCritSectNoOp = 285            ' Critical section options will block task

  ' Interrupts

Global Const DL_IntNotSupported = 290           ' Interrupts not supported
Global Const DL_InvIRQ = 295                    ' Invalid interrupt level
Global Const DL_IntInUseErr = 300               ' Interrupt(s) are in use
Global Const DL_IntOvrErr = 305                 ' Interrupt overrun

  ' DMA

Global Const DL_DMANotSupported = 310           ' DMA not supported
Global Const DL_InvDMA = 315                    ' Invalid DMA level
Global Const DL_DMAInUseErr = 320               ' DMA channel(s) are in use
Global Const DL_DMAIntActiveErr = 325           ' DMA/Interrupt already active
Global Const DL_DMABufferErr = 330              ' DMA buffer straddles physical page
Global Const DL_VDS_NotContig = 335             ' DMA region not in contiguous memory
Global Const DL_VDS_NotLocked = 340             ' Unable to lock memory pages for DMA
Global Const DL_VDS_NoBuffer = 345              ' No DMA buffer available
Global Const DL_VDS_RegionTooLarge = 350        ' DMA region too large for buffer
Global Const DL_VDS_BufferBusy = 355            ' DMA buffer currently in use
Global Const DL_VDS_RegionInvalid = 360         ' Invalid DMA memory region
Global Const DL_VDS_RegionNotLocked = 365       ' DMA region was not locked
Global Const DL_VDS_TooManyPages = 370          ' Number of physical pages was greater than table length
Global Const DL_VDS_InvalidBufferId = 375       ' Invalid DMA buffer ID
Global Const DL_VDS_CopyOutOfRange = 380        ' Copy out of DMA buffer range
Global Const DL_VDS_InvalidDMAChannel = 385     ' Invalid DMA channel number
Global Const DL_VDS_CountOverflow = 390         ' Disable count overflow
Global Const DL_VDS_CountUnderflow = 395        ' Disable count underflow
Global Const DL_DMANoIntErr = 400               ' Interrupt required for multiple DMA buffering

  ' Events

Global Const DL_EventNotSupErr = 405            ' Requested event not supported for operation
Global Const DL_BadEventErr = 410               ' Invalid event type specified
Global Const DL_TimingEventNotSupErr = 415      ' Requested timing event not supported
Global Const DL_StartEventNotSupErr = 420       ' Requested start event not supported
Global Const DL_StopEventNotSupErr = 425        ' Requested stop event not supported
Global Const DL_EventComboNotSupErr = 430       ' Requested combination of events not supported

  ' Analog Events

Global Const DL_AEvtChnErr = 435                ' Invalid analog event channel
Global Const DL_AEvtGainErr = 440               ' Invalid analog event gain
Global Const DL_AEvtLvlErr = 445                ' Invalid analog event thresholds

  ' Digital Events

Global Const DL_DEvtChnErr = 450                ' Invalid digital event channel
Global Const DL_DigMaskErr = 455                ' Digital mask bits outside hardware range
Global Const DL_DigPatErr = 460                 ' Digital pattern bits outside mask range

  ' Time Events

Global Const DL_TEvtChnErr = 465                ' Invalid time event channel

  ' Rate Events

Global Const DL_REvtChnErr = 470                ' Invalid rate event channel
Global Const DL_TimerFuncErr = 475              ' Function not supported by requested timer
Global Const DL_NoConvDelay = 480               ' Conversion delay not specified
Global Const DL_BadTimerChan = 485              ' Counter/timer channel is invalid
Global Const DL_BadTimerDelay = 490             ' Counter value is invalid
Global Const DL_RolloverErr = 495               ' Counter overflow
Global Const DL_InversionWarn = 500             ' Pulse output is inverted
Global Const DL_IntervalNotSupErr = 505         ' Time interval on 1 timer is not supported
Global Const DL_HardwareLimWarn = 510           ' Consult manual for hardware limitations
Global Const DL_OnCountInvalid = 515            ' Pulse on-count > specified period
Global Const DL_BadGateValue = 520              ' Gate value is invalid
Global Const DL_BadClockValue = 525             ' Clock value is invalid
Global Const DL_BadCTModeErr = 530              ' Counter/timer mode is not supported
Global Const DL_GateNotAllowed = 535            ' Counter/timer gate mode not allowed
Global Const DL_NoPulsesErr = 540               ' Requested number of pulses not supported
Global Const DL_NoExtClkErr = 545               ' External clocking required
Global Const DL_NoIntClkErr = 550               ' Internal clocking required

  ' Errors detected during tasks

Global Const DL_ClockingErr = 555               ' Clock rate too fast to process
Global Const DL_SettlingErr = 560               ' Multiplexer settling error
Global Const DL_DataLostErr = 565               ' Data lost


  ' Errors detected with hardware resources

Global Const DL_errTimeout = 570                ' Hardware timeout
Global Const DL_errInternalTimer = 575          ' Internal timer request failed
Global Const DL_errNoFIFO = 580                 ' FIFO not detected
Global Const DL_errNoDASRam = 585               ' On-board RAM not detected
Global Const DL_errDACLinearity = 590           ' DAC linearity test failed
Global Const DL_errADCalibration = 595          ' A/D calibration error
Global Const DL_errDACalibration = 600          ' D/A calibration error

Global Const DL_DRIVERNAME = &H3FFF             ' Name of DriverLINX
Global Const DL_COPYRIGHT = &H3FFE              ' Copyright notice
Global Const DL_DRIVERLINXVERSION = &H3FFD      ' Specific version of DriverLINX

  ' Following are vendor codes

Global Const DL_ADVANTECH_LTD = &H2FF0          ' Advantech
Global Const DL_COMPUTER_BOARDS = &H2FE0        ' Computer Boards
Global Const DL_INDUSTRIAL_COMPUTER = &H2FD0    ' Industrial Computer Source
Global Const DL_KEITHLEY_METRABYTE = &H2FC0     ' Keithley MetraByte
Global Const DL_SCIENTIFIC_SOLUTIONS = &H2FB0   ' Scientific Solutions
Global Const DL_SOLTEC = &H2FA0                 ' Soltec
Global Const DL_DATA_TRANSLATION = &H2F90       ' Data Translation
Global Const DL_ADAC_CORPORATION = &H2F80       ' ADAC Corporation
Global Const DL_ANALOGIC = &H2F70               ' Analogic Corporation



